require "ZomboWin/ZomboWinConfig"

--- Setup ModOptions
local ZomboWinModOptions = {
	options = {
		box1 = true,
		box3 = true,
		box4 = true,
		dropdown1 = 2,	---hostile bandits upon release
		box2 = false,
	},
	names = {
		box1 = getText("IGUI_Main"),
		box3 = getText("IGUI_Couple"),
		box4 = getText("IGUI_Solo"),
		dropdown1 = getText("IGUI_banditRelease");
		box2 = getText("IGUI_Debug_Mode"),
	},
	mod_id = "ZomboWinFramework",	
	mod_shortname = "Project ZomboWin Options",
}

ZomboWinConfig.ModOptions = ZomboWinModOptions

if ModOptions and ModOptions.getInstance then
	local settings = ModOptions:getInstance(ZomboWinConfig.ModOptions)
	
	do
		ZomboWinModOptions.options_data.box1.tooltip = "IGUI_Main_TT"
		ZomboWinModOptions.options_data.box3.tooltip = "IGUI_Couple_TT"
		ZomboWinModOptions.options_data.box4.tooltip = "IGUI_Solo_TT"
		ZomboWinModOptions.options_data.box2.tooltip = "IGUI_Debug_Mode_TT"
	end
	
	do
		local dropdown = ZomboWinModOptions.options_data.dropdown1
		ZomboWinModOptions.options_data.dropdown1.tooltip = "IGUI_banditRelease_Tooltip"
		table.insert(dropdown, "Never")
		table.insert(dropdown, "Sometimes")
		table.insert(dropdown, "Always")
	end
	
	--- Sandbox/Hide the options in multiplayer
	if isClient() then
		for option, _ in pairs(ZomboWinModOptions.options) do
			local option = settings:getData(option)
			option.sandbox_path = "ZomboWinSection"
		end
	end
end
